 aR  w - mP9      h	 o     nSystem-wide
	NAME ScreenInterface

; This is ScrIntfc.ASM

SysDep_CGROUP GROUP SysDep_CODE
SysDep_DGROUP GROUP SysDep_DATA
OS_CGROUP GROUP OS_CODE
CGROUP GROUP CODE

EXTRN	ExitProgram: FAR
EXTRN	myRomID: ABS


PUBLIC	AttachAndReadGRiDRamHeader
PUBLIC	LoadScrDrvrAndDetachGRiDRam
PUBLIC	PutOsCGroupIntoEms

PUBLIC	myEmsSlot, osCGrpAddr, osCGrpSize

PUBLIC	GfxSetPixel, GfxClrPixel, GfxInvertPixel, GfxTestPixel
PUBLIC	GfxDrawLine, GfxEraseLine, GfxInvertLine
PUBLIC	BitEraseHLine, BitInvertHLine
PUBLIC	BlitRectangle, CpCopyRectangle, CpDrawChars
PUBLIC	xCpScreenInfo, SetScreenMode, CpAddrOfSystemFont


SysDep_DATA SEGMENT PUBLIC 'DATA'

gFileConn   DW 1 DUP (?)
osCGrpAddr  DW 1 DUP (?)
osCGrpSize  DW 1 DUP (?)
error	   DW 1 DUP (?)

drvrAddr    DW 1 DUP (?)
lnkrOffset  DW 1 DUP (?)
lnkrSegment DW 1 DUP (?)

signature   DW 1 DUP (?)
remainder   DW 1 DUP (?)
blocks512   DW 1 DUP (?)
numFixups   DW 1 DUP (?)
misc        DW 8 DUP (?)
fixupsOff   DW 1 DUP (?)

drvrSig     DW 1 DUP (?)
lnkrLen	   DW 1 DUP (?)
drvrLen     DW 1 DUP (?)
drvrMisc    DW 5 DUP (?)

myEmsSlot   DB 1 DUP (?)
tempEmsSlot DB 1 DUP (?)


EXTRN	integridEmsAlloc: BYTE
EXTRN	startAddress: WORD	; (Of EMS Area)

SysDep_DATA ENDS


CODE SEGMENT PUBLIC 'CODE'
	EXTRN  EmsAllocate: FAR
CODE ENDS


OS_CODE SEGMENT PUBLIC 'CODE'
	EXTRN  endOfOsCGroup: FAR
OS_CODE ENDS


SysDep_CODE SEGMENT PUBLIC 'CODE'
	ASSUME CS:SysDep_CGROUP, DS:SysDep_DGROUP

; AttachToGRiDRamFile

; This routine will find and attach to the file GRiDRam.Exe
; It also will read in some header info needed by some other routines below

gridName    DB 'GRiD.Exe', 0
gridRomName DB 'GRiDRom.Exe', 0

AttachAndReadGRiDRamHeader PROC NEAR
	MOV	CX, CS
	MOV	DX, OFFSET gridName	; Assume GRiD.Exe
	MOV	AX, myRomID	; If my rom ID
	OR	AX, AX	; is zero then
	JZ	TryAttachHere	; must be running GRiD.Exe

	MOV	DX, OFFSET gridRomName	; else must be running GRiDR.Exe

TryAttachHere:
	CALL	AttachToFile
	JNC	ReadGRiDRamHeader

	CALL	AttachWithPath
	JC	AttachToGRiDRamError

ReadGRiDRamHeader:
	MOV	gFileConn, AX
	MOV	BX, AX
	MOV	DX, OFFSET signature
	MOV	CX, 26
	MOV	AH, 3FH
	INT	21H
	JNC	AttachToGRiDRamExit

AttachToGRiDRamError:
	JMP	LoadDriverError

AttachToGRiDRamExit:
	RET
AttachAndReadGRiDRamHeader ENDP
$EJECT

; Attach Using Path

pathID DB 'PATH='

AttachWithPath PROC NEAR
	MOV	AH, 51H
	INT	21H	; Find InteGRiD's PDB
	MOV	ES, BX
	MOV	BX, 02CH	; Offset 2C contains the environment
	MOV	AX, ES:[BX]

	CLD
	MOV	ES, AX
	XOR	DI, DI	; ES:DI => environment

AttachWithPathLoop:
	PUSH	DS	; Save data pointer
	MOV	AX, CS
	MOV	DS, AX
	MOV	SI, OFFSET pathID
	MOV	CX, 5
	REP	CMPSB	; Look for 'PATH='
	POP	DS	; Restore data pointer
	JE	AttachWithPathPart2	; Continue if PATH= has been found

	DEC	DI	; Back up 1 in case it was a zero
	MOV	AL, 0	; Search for next envir item indicator
	MOV	CX, 8000H	; Nothing in environment should be > 32K
	REPNE SCASB	; Search for beginning of next envir item
	JNE	AttachWithPathNotFound	; Error if no zero found

	CMP	ES:[DI], AL	; If next item begins with non-zero
	JNE	AttachWithPathLoop	; then keep looking for PATH=
	JMP	AttachWithPathNotFound	; else PATH= does not exist

AttachWithPathPart2:
	MOV	BX, 5	; 80 bytes is large enough for longest name
	MOV	AH, 48H	; Allocate blocks of memory
	INT	21H	; Call MsDos
	JC	AttachWithPathNotFound	; Exit if error

	PUSH	DS	; Save data pointer

	PUSH	ES	; Make DS:SI => Path definition
	MOV	ES, AX	; And ES:DI => Path for attach
	POP	DS
	MOV	SI, DI

AttachBuildPathLoop:
	XOR	AX, AX	; Set AL to end marker and for DI soon
	CMP	DS:[SI], AL	; If at end of path definition
	JE	AttachErrorAndFreeBuffer	; then done, but attach not successful

	XCHG	DI, AX	; Path prefix offset inited to 0
	CLD

AttachGetNextChar:
	LODSB	; Get next char
	CMP	AL, 0	; If next char is not end of path
	JNE	AttachMaybeSemiColon	; then do something with it

	DEC	SI	; Dec SI so that end will be found next time
	JMP	SHORT AttachTryAttachNow	; Done building path prefix

AttachMaybeSemiColon:
	CMP	AL, ';'	; If next char is ';' then
	JE	AttachTryAttachNow	; done building path prefix

	CMP	AL, 20H	; If char is space
	JE	AttachGetNextChar	; then ignore it

	CMP	AL, 09H	; If char is tab
	JE	AttachGetNextChar	; then ignore it

	STOSB	; Else append char to path prefix
	JMP	SHORT AttachGetNextChar	; And get another one

AttachTryAttachNow:
	MOV	DL, ES:[DI-1]	; Get last character in path
	CMP	DL, ':'	; If it was the drive delimeter
	JE	AttachAppendFileName	; then don't append '\'

	MOV	AL, '\'
	CMP	DL, AL	; If it was a directory delimeter
	JE	AttachAppendFileName	; then don't append '\'

	STOSB	; Else append '\' before appending filename

AttachAppendFileName:
	MOV	AX, 'RG'
	STOSW
	MOV	AX, 'Di'
	STOSW

	MOV	AX, myRomID	; If my rom ID
	OR	AX, AX	; is zero then
	JZ	DontAppendRomPart	; must be running GRiD.Exe

	MOV	AL, 'R'	; Change 'GRiD'(.Exe)
	STOSB
	MOV  AX, 'mo'	; to 'GRiDRom'(.Exe)
	STOSW

DontAppendRomPart:
	MOV	AX, 'E.'
	STOSW
	MOV	AX, 'ex'
	STOSW	; Append 'GRiD.Exe'
	MOV	AL, 0
	STOSB	; End attach path with zero

	MOV	CX, ES	; Attach to file takes pointer to path
	XOR	DX, DX	; in CX:DX
	CALL	AttachToFile	; Try to attach to file
	JC	AttachBuildPathLoop	; Try again if not successful

AttachSuccessAndFreeBuffer:
	POP	DS	; Restore data pointer
	PUSH	AX	; Save file connection
	MOV	AH, 49H	; Free memory block that held attach string
	INT	21H	; Call MsDos
	POP	AX	; Restore file connection
	RET		; Error indication (C/NC) set by MsDos call

AttachErrorAndFreeBuffer:
	POP	DS	; Restore data pointer
	MOV	AH, 49H	; Free memory block that held attach string
	INT	21H	; Call MsDos

AttachWithPathNotFound:
	STC		; Indicate error
	RET
AttachWithPath ENDP
$EJECT

; Attach To File

; Entry
;	CX:DX => File name to be attached to

; Exit
;	AX = file conn
;	Carry flag indicates error/okay

; This routine should not change the direction flag
; or ES, DI, DS, SI.

AttachToFile PROC NEAR
	PUSH	DS

	MOV	DS, CX	; File name must be in DS:DX
	MOV	AX, 3D00H	; Attach with read access
	INT	21H

	POP	DS
	RET
AttachToFile ENDP
$EJECT

; Put OsCGROUP Into EMS
;
; This routine will try to relocate OsCGROUP into EMS
;

PutOsCGroupIntoEMS PROC NEAR
	MOV	osCGrpAddr, 0	; Init free blk addr to 0
	MOV	myEmsSlot, 0FEH	; Init my ems slot to nullSlot
	MOV	AX, myRomID	; If inteGRiD executes
	OR	AX, AX	; from ROM then
	JNZ	PutOsCGroupExitJmp	; don't put it into EMS

	MOV	inteGRiDEmsAlloc, 0FFH
	MOV	AX, 0FFFFH	; Allocate 64K block from EMS
	PUSH	AX
	XOR	AX, AX
	PUSH	AX	; pid = system pid
	PUSH	AX	; uniqueID = 0
	LEA	AX, error
	PUSH	DS
	PUSH	AX
	CALL	EmsAllocate
	MOV	tempEmsSlot, AL
	MOV	integridEmsAlloc, 0

	CMP	error, 0
	JE	PutOsCGroupSeek

PutOsCGroupExitJmp:
	JMP	PutOsCGroupExit

; Seek to the beginning of the fixupp table information

PutOsCGroupSeek:
	MOV	AX, 4200H
	MOV	BX, gFileConn
	XOR	CX, CX
	MOV	DX, fixupsOff
	INT	21H
	JC	PutOsCGroupExitHop

; Allocate enough memory to hold the fixupp table

	PUSH	BX
	MOV	BX, numFixups
	SHR	BX, 1
	SHR	BX, 1
	INC	BX
	MOV	AH, 48H
	INT	21H
	POP	BX
	JC	PutOsCGroupExitHop

; Read in fixupp table into memory

	PUSH	DS
	MOV	CX, numFixups
	SHL	CX, 1
	SHL	CX, 1
	MOV	DS, AX
	MOV	ES, AX
	XOR	DX, DX
	MOV	AH, 3FH
	INT	21H
	POP	DS

PutOsCGroupExitHop:
	JC	PutOsCGroupExit

; Get base address of program (Returned in BX)

	MOV	AH, 51H
	INT	21H
	ADD	BX, 10H	; Skip over program prefix

	PUSH	DS
	PUSH	BP

	CLD
	MOV	CX, numFixups
	MOV	DX, startAddress	; Start address of EMS area
	PUSH	ES
	POP	DS
	XOR	SI, SI
	MOV	BP, OS_CGROUP

PutOsCGroupLoop:
	LODSW
	XCHG	DI, AX
	LODSW
	ADD	AX, BX
	MOV	ES, AX
	MOV	AX, ES:[DI]
	CMP	AX, BP
	JNE	PutOsCGroupNext

	MOV	AX, DX
	STOSW

PutOsCGroupNext:
	LOOP PutOsCGroupLoop

; Free up the ram space used to store the fixup table

	PUSH	DS
	POP	ES
	MOV	AH, 49H
	INT	21H

; Copy the old OS_CGROUP into the new OS_CGROUP

	MOV	DS, BP
	MOV	ES, DX
	XOR	SI, SI
	XOR	DI, DI
	MOV	CX, OFFSET OS_CGROUP:endOfOsCGroup
	SHR	CX, 1
	CLD
	REP	MOVSW

; Zero out the old OS_CGROUP area

	MOV	AX, DS
	MOV	ES, AX
	XOR	DI, DI
	XOR	AX, AX
	MOV	CX, OFFSET OS_CGROUP:endOfOsCGroup
	SHR	CX, 1
;	CLD
	REP	STOSW

	MOV	AX, DS	; Save Old OS_CGROUP addr in AX

	POP	BP
	POP	DS

	MOV	osCGrpAddr, AX
	MOV	AX, OFFSET OS_CGROUP:endOfOsCGroup
	MOV	CL, 4
	SHR	AX, CL
	INC	AX
	MOV	osCGrpSize, AX

	MOV	AL, tempEmsSlot
	MOV	myEmsSlot, AL

PutOsCGroupExit:
	RET
PutOsCGroupIntoEMS ENDP
$EJECT

LoadScrDrvrAndDetachGRiDRam PROC NEAR

; Seek to position where screen driver is supposed to be

	MOV	BX, gFileConn
	MOV	AX, blocks512
	DEC	AX
	MOV	DX, 512
	MUL	DX
	ADD	AX, remainder
	ADC	DX, 0
	MOV	CX, AX
	MOV	DI, 0FH
	AND	CX, DI
	JZ	DriverSizeIsMod16

	NEG	CX
	AND	CX, DI
	ADD	AX, CX
	ADC	DX, 0

DriverSizeIsMod16:
	XCHG	DX, AX
	XCHG	CX, AX
	MOV	AX, 4200H
	INT	21H
	JC	LoadDriverErrorHop

; Read in header of screen driver overlay

;	MOV	BX, gFileConn	; BX preserved above
	MOV	DX, OFFSET drvrSig
	MOV	CX, 16
	MOV	AH, 3FH
	INT	21H
	JC	LoadDriverErrorHop

; Verify header, determine size of driver

	CMP	drvrSig, 'DS'
	JE	LoadScreenDriverHeaderOK
	JMP	LoadDriverError

; Allocate enough memory for driver linker

LoadScreenDriverHeaderOK:
	MOV	DX, lnkrLen
	MOV	CL, 4
	SHR	DX, CL
	XCHG	BX, DX
	MOV	AH, 48H
	INT	21H
	XCHG	DX, BX
	MOV	lnkrSegment, AX
	MOV	lnkrOffset, 0
	JC	LoadDriverErrorHop

; Read in driver linker

	PUSH DS
;	MOV	BX, gFileConn	; BX preserved above
	MOV	CX, lnkrLen
	XOR	DX, DX
	MOV	DS, AX
	MOV	AH, 3FH
	INT	21H
	POP	DS
	JC	LoadDriverErrorHop

; Call driver linker to get offset (in DX) and length (in BX) of actual driver

	CALL	DWORD PTR lnkrOffset

; Free memory for driver linker

	MOV	ES, lnkrSegment
	MOV	AH, 49H
	INT	21H

LoadDriverErrorHop:
	JC	LoadDriverError

; Allocate enough memory for driver

	PUSH	BX	; Save actual length of driver
	MOV	CL, 4
	SHR	BX, CL

	MOV	AX, osCGrpAddr
	OR	AX, AX
	JZ	LoadSDAllocate

	SUB	osCGrpSize, BX
	ADD	osCGrpAddr, BX
	POP	SI	; Restore actual length of driver
	JMP	SHORT LoadSDSeek

LoadSDAllocate:
	MOV	AH, 48H
	INT	21H
	POP	SI	; Restore actual length of driver
	JC	LoadDriverError

; Seek to file position of beginning of screen driver

LoadSDSeek:
	MOV	drvrAddr, AX
	MOV	BX, gFileConn
	MOV	AX, 4201H	; Seek forward by this amount (in CX:DX)
	XOR	CX, CX
	SUB	DX, lnkrLen	; Already been past linker
	INT	21H
	JC	LoadDriverError

; Read in driver

	PUSH	DS
	MOV	AX, drvrAddr
	MOV	DS, AX
	MOV	CX, SI
	XOR	DX, DX
	MOV	AH, 3FH
	INT	21H
	POP	DS
	JC	LoadDriverError

;	MOV	BX, gFileConn
	MOV	AH, 3EH
	INT	21H
	JMP	SHORT LoadDriverExit

LoadDriverError:
	MOV	AX, myRomID	; If my rom ID
	OR	AX, AX	; is zero then
	MOV	AX, 0FFFEH	; (0FFFEH is error number for GRiD.Exe)
	JZ	LoadDriverErrorCont	; must be running GRiD.Exe

	DEC	AX	; (0FFFDH is error number for GRiDRom.Exe)

LoadDriverErrorCont:
	PUSH	AX
	XOR	AX, AX
	PUSH	AX
	PUSH	AX
	CALL	ExitProgram

LoadDriverExit:
	RET
LoadScrDrvrAndDetachGRiDRam ENDP
$EJECT

GfxSetPixel LABEL FAR
	MOV	AL, 0
	JMP	SHORT JmpToScrDriver

GfxClrPixel LABEL FAR
	MOV	AL, 1
	JMP	SHORT JmpToScrDriver

GfxInvertPixel LABEL FAR
	MOV	AL, 2
	JMP	SHORT JmpToScrDriver

GfxTestPixel LABEL FAR
	MOV	AL, 3
	JMP	SHORT JmpToScrDriver

GfxDrawLine LABEL FAR
	MOV	AL, 4
	JMP	SHORT JmpToScrDriver

GfxEraseLine LABEL FAR
	MOV	AL, 5
	JMP	SHORT JmpToScrDriver

GfxInvertLine LABEL FAR
	MOV	AL, 6
	JMP	SHORT JmpToScrDriver

BitInvertHLine LABEL FAR
	MOV	AL, 7
	JMP	SHORT JmpToScrDriver

BitEraseHLine LABEL FAR
	MOV	AL, 8
	JMP	SHORT JmpToScrDriver

CpCopyRectangle LABEL FAR
	MOV	AL, 9
	JMP	SHORT JmpToScrDriver

BlitRectangle LABEL FAR
	MOV	AL, 10
	JMP	SHORT JmpToScrDriver

xCpScreenInfo LABEL FAR
	MOV	AL, 11
	JMP	SHORT JmpToScrDriver

CpDrawChars LABEL FAR
	MOV	AL, 12
	JMP	SHORT JmpToScrDriver

SetScreenMode LABEL FAR
	MOV	AL, 13
	JMP	SHORT JmpToScrDriver

CpAddrOfSystemFont LABEL FAR
	MOV	AL, 14
;	JMP	SHORT JmpToScrDriver	; WARNING- Remove comment at left if adding
;			; more entries after this one !!!

JmpToScrDriver:
	MOV	AH, 0
	SHL	AX, 1
	XCHG	BX, AX
	MOV	AX, SysDep_DGROUP
	MOV	ES, AX
	MOV	ES, ES:drvrAddr
	MOV	AX, WORD PTR ES:[BX]
	PUSH	ES
	PUSH	AX

LongRet PROC FAR
	RET
LongRet ENDP


SysDep_CODE ENDS

	END
